<?php


namespace App\Http\Controllers\User;

use App\Enums\WithdrawMethodStatus;
use App\Http\Controllers\Controller;
use App\Models\UserAccount;
use App\Models\WithdrawMethod;
use App\Services\Withdraw\WithdrawAccountService;

class WithdrawAccountController extends Controller
{
    private $accountService;

    public function __construct(WithdrawAccountService $accountService)
    {
        $this->accountService = $accountService;
    }

    /**
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @version 1.0.0
     * @since 1.0
     */
    public function view()
    {
        $wdMethods = $this->accountService->getMethods();
        $accounts = $this->accountService->getAccounts($wdMethods);

        return view('user.account.withdraw-account', compact('accounts', 'wdMethods'));
    }
}
