<?php

namespace NioModules\Bank\Controllers;

use App\Http\Controllers\Controller;
use App\Models\UserTempMeta;

class TransactionConfirmationController extends Controller
{
    public function depositComplete()
    {
        $tempMeta = UserTempMeta::where('user_id', auth()->id())
            ->where('meta_key', 'deposit_details')
            ->first();
        $depositDetails = data_get($tempMeta, 'meta_value');

        if (filled($tempMeta) && filled($depositDetails)) {
            if (data_get($depositDetails, 'flush') == true) {
                $tempMeta->delete();
            } else {
                $depositDetails['flush'] = true;
                $tempMeta->meta_value = $depositDetails;
                $tempMeta->save();
            }
            $depositDetails['order'] = (object) $depositDetails['order'];

            return view('Bank::deposit-complete', $depositDetails);
        }

        return redirect()->route('dashboard');
    }
}
