<?php

namespace App\Services\Withdraw;

use App\Enums\WithdrawMethodStatus;
use App\Models\UserAccount;
use App\Models\WithdrawMethod;

class WithdrawAccountService
{
    public function getMethods()
    {
        return WithdrawMethod::whereIn('slug', array_column(available_withdraw_methods(), 'slug'))
            ->where('status', WithdrawMethodStatus::ACTIVE)
            ->get()->filter(function ($item) {
                return filled($item->is_active);
            })->keyBy('slug');
    }

    public function getAccounts($wdMethods = null)
    {
        $wdMethods = $wdMethods ?: $this->getMethods();

        return UserAccount::where('user_id', auth()->user()->id)
            ->whereIn('slug', $wdMethods->keys()->all())
            ->get();
    }
}
