<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class Google2faRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'google2fa_code' => 'required',
            'google2fa_secret' => $this->state == 'disable' ? 'nullable' : 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'google2fa_code.required' => __('The authentication code is required to :state.', ['state' => $this->state]),
            'google2fa_secret.required' => __('The secret key is missing for authentication.'),
        ];
    }
}
